# group-array [![NPM version](https://img.shields.io/npm/v/group-array.svg?style=flat)](https://www.npmjs.com/package/group-array) [![NPM monthly downloads](https://img.shields.io/npm/dm/group-array.svg?style=flat)](https://npmjs.org/package/group-array)  [![NPM total downloads](https://img.shields.io/npm/dt/group-array.svg?style=flat)](https://npmjs.org/package/group-array) [![Linux Build Status](https://img.shields.io/travis/doowb/group-array.svg?style=flat&label=Travis)](https://travis-ci.org/doowb/group-array)

> Group array of objects into lists.

## Table of Contents

- [Install](#install)
- [Usage](#usage)
- [Examples](#examples)
- [About](#about)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save group-array
```

## Usage

```js
var groupArray = require('group-array');
```

## Examples

```js
var arr = [
  {tag: 'one', content: 'A'},
  {tag: 'one', content: 'B'},
  {tag: 'two', content: 'C'},
  {tag: 'two', content: 'D'},
  {tag: 'three', content: 'E'},
  {tag: 'three', content: 'F'}
];

// group by the `tag` property
groupArray(arr, 'tag');
```

**results in:**

```js
{
  one: [
    {tag: 'one', content: 'A'},
    {tag: 'one', content: 'B'}
  ],
  two: [
    {tag: 'two', content: 'C'},
    {tag: 'two', content: 'D'}
  ],
  three: [
    {tag: 'three', content: 'E'},
    {tag: 'three', content: 'F'}
  ]
}
```

**Group by multiple, deeply nested properties**

```js
// given an array of object, like blog posts...
var arr = [
  { data: { year: '2016', tag: 'one', month: 'jan', day: '01'}, content: '...'},
  { data: { year: '2016', tag: 'one', month: 'jan', day: '01'}, content: '...'},
  { data: { year: '2016', tag: 'one', month: 'jan', day: '02'}, content: '...'},
  { data: { year: '2016', tag: 'one', month: 'jan', day: '02'}, content: '...'},
  { data: { year: '2016', tag: 'one', month: 'feb', day: '10'}, content: '...'},
  { data: { year: '2016', tag: 'one', month: 'feb', day: '10'}, content: '...'},
  { data: { year: '2016', tag: 'one', month: 'feb', day: '12'}, content: '...'},
  { data: { year: '2016', tag: 'one', month: 'feb', day: '12'}, content: '...'},
  { data: { year: '2016', tag: 'two', month: 'jan', day: '14'}, content: '...'},
  { data: { year: '2016', tag: 'two', month: 'jan', day: '14'}, content: '...'},
  { data: { year: '2016', tag: 'two', month: 'jan', day: '16'}, content: '...'},
  { data: { year: '2016', tag: 'two', month: 'jan', day: '16'}, content: '...'},
  { data: { year: '2016', tag: 'two', month: 'feb', day: '18'}, content: '...'},
  { data: { year: '2017', tag: 'two', month: 'feb', day: '18'}, content: '...'},
  { data: { year: '2017', tag: 'two', month: 'feb', day: '10'}, content: '...'},
  { data: { year: '2017', tag: 'two', month: 'feb', day: '10'}, content: '...'},
  { data: { year: '2017', tag: 'three', month: 'jan', day: '01'}, content: '...'},
  { data: { year: '2017', tag: 'three', month: 'jan', day: '01'}, content: '...'},
  { data: { year: '2017', tag: 'three', month: 'jan', day: '02'}, content: '...'},
  { data: { year: '2017', tag: 'three', month: 'jan', day: '02'}, content: '...'},
  { data: { year: '2017', tag: 'three', month: 'feb', day: '01'}, content: '...'},
  { data: { year: '2017', tag: 'three', month: 'feb', day: '01'}, content: '...'},
  { data: { year: '2017', tag: 'three', month: 'feb', day: '02'}, content: '...'},
  { data: { year: '2017', tag: 'three', month: 'feb', day: '02'}, content: '...'}
]
```

Pass a list or array of properties:

```js
groupArray(arr, 'data.year', 'data.tag', 'data.month', 'data.day');
```

**Results in something like this: (abbreviated)**

```js
{ '2016': 
   { one: 
      { jan: 
         { '01': 
            [ { data: { year: '2016', tag: 'one', month: 'jan', day: '01' },
                content: '...' },
              { data: { year: '2016', tag: 'one', month: 'jan', day: '01' },
                content: '...' } ],
           '02': 
            [ { data: { year: '2016', tag: 'one', month: 'jan', day: '02' },
                content: '...' },
              { data: { year: '2016', tag: 'one', month: 'jan', day: '02' },
                content: '...' } ] },
        feb: 
         { '10': 
            [ { data: { year: '2016', tag: 'one', month: 'feb', day: '10' },
                content: '...' },
              { data: { year: '2016', tag: 'one', month: 'feb', day: '10' },
                content: '...' } ],
           '12': 
            [ { data: { year: '2016', tag: 'one', month: 'feb', day: '12' },
                content: '...' },
              { data: { year: '2016', tag: 'one', month: 'feb', day: '12' },
                content: '...' } ] } },
     two: 
      { jan: 
         { '14': 
            [ { data: { year: '2016', tag: 'two', month: 'jan', day: '14' },
                content: '...' },
              { data: { year: '2016', tag: 'two', month: 'jan', day: '14' },
                content: '...' } ],
           '16': 
            [ { data: { year: '2016', tag: 'two', month: 'jan', day: '16' },
                content: '...' },
              { data: { year: '2016', tag: 'two', month: 'jan', day: '16' },
                content: '...' } ] },
        feb: 
         { '18': 
            [ { data: { year: '2016', tag: 'two', month: 'feb', day: '18' },
                content: '...' } ] } } },
  '2017': 
   { two: 
      { feb: 
         { '10': 
            [ { data: { year: '2017', tag: 'two', month: 'feb', day: '10' },
                content: '...' },
              { data: { year: '2017', tag: 'two', month: 'feb', day: '10' },
                content: '...' } ],
           '18': 
            [ { data: { year: '2017', tag: 'two', month: 'feb', day: '18' },
                content: '...' } ] } },
     three: 
      { jan: 
         { '01': 
            [ { data: { year: '2017', tag: 'three', month: 'jan', day: '01' },
                content: '...' },
              { data: { year: '2017', tag: 'three', month: 'jan', day: '01' },
                content: '...' } ],
           '02': 
            [ { data: { year: '2017', tag: 'three', month: 'jan', day: '02' },
                content: '...' },
              { data: { year: '2017', tag: 'three', month: 'jan', day: '02' },
                content: '...' } ] },
        feb: 
         { '01': 
            [ { data: { year: '2017', tag: 'three', month: 'feb', day: '01' },
                content: '...' },
              { data: { year: '2017', tag: 'three', month: 'feb', day: '01' },
                content: '...' } ],
           '02': 
            [ { data: { year: '2017', tag: 'three', month: 'feb', day: '02' },
                content: '...' },
              { data: { year: '2017', tag: 'three', month: 'feb', day: '02' },
                content: '...' } ] } } } }
```

## About

### Related projects

* [arr-flatten](https://www.npmjs.com/package/arr-flatten): Recursively flatten an array or arrays. This is the fastest implementation of array flatten. | [homepage](https://github.com/jonschlinkert/arr-flatten "Recursively flatten an array or arrays. This is the fastest implementation of array flatten.")
* [get-value](https://www.npmjs.com/package/get-value): Use property paths (`a.b.c`) to get a nested value from an object. | [homepage](https://github.com/jonschlinkert/get-value "Use property paths (`a.b.c`) to get a nested value from an object.")
* [group-object](https://www.npmjs.com/package/group-object): Group object keys and values into lists. | [homepage](https://github.com/doowb/group-object "Group object keys and values into lists.")
* [union-value](https://www.npmjs.com/package/union-value): Set an array of unique values as the property of an object. Supports setting deeply… [more](https://github.com/jonschlinkert/union-value) | [homepage](https://github.com/jonschlinkert/union-value "Set an array of unique values as the property of an object. Supports setting deeply nested properties using using object-paths/dot notation.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 23 | [doowb](https://github.com/doowb) |
| 6 | [jonschlinkert](https://github.com/jonschlinkert) |
| 1 | [cperryk](https://github.com/cperryk) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Brian Woodward**

* [github/doowb](https://github.com/doowb)
* [twitter/doowb](https://twitter.com/doowb)

### License

Copyright © 2017, [Brian Woodward](https://github.com/doowb).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.2, on February 24, 2017._