<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\DatekModel;
use App\Models\MappingModel;
class Datek extends BaseController
{
	public function __construct(){
		
		$this->datek = new DatekModel();
		$this->map = new MappingModel();
	}
    public function index()
    {
        $data =[
			'title'=>'Datek',
			'datek'=>$this->datek->findAll(),
			'map'=>$this->map->getmap(),
			'validation' => \Config\Services::validation()
		];

        return view('datek/index',$data);
    }

    public function save(){
		if (!$this->validate([
			'ne'=>[
				'rules'=>'is_unique[datek.ne]',
				'errors'=>[
					'is_unique'=>'{field}sudah terdaftar.'
				]
			],
			't_ne'=>[
				'rules'=>'is_unique[datek.t_ne]',
				'errors'=>[
					'is_unique'=>'{field}sudah terdaftar.'
				]
			],

		])){
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}
		$this->datek->save([
			'ne'=> $this->request->getVar('ne'),
			't_ne'=> $this->request->getVar('ne')
		]);
		return redirect()->to(site_url("datek"));
	}

	public function update($id){
		$this->datek->update($id,[
			'ne'=> $this->request->getVar('ne'),
			't_ne'=> $this->request->getVar('ne')
		]);
		return redirect()->to(site_url("datek"));
	}
	public function delete($tamp){
		$this->datek->delete($tamp);
		$this->map->where('ne_a',$tamp)->delete();
		$this->map->where('ne_b',$tamp)->delete();
		return redirect()->to('datek');	
	}

}
