<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
//$routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('link', 'Link::index');
$routes->get('datek', 'Datek::index');
$routes->get('hostname', 'Hostname::index');
$routes->get('sistem', 'Stransport::index');
$routes->get('mapping', 'Mapping::index');

$routes->post('link/create', 'Link::save');
$routes->post('link/create', 'Link::save');
$routes->post('hostname/create', 'Hostname::save');
$routes->post('sistem/create', 'Stransport::save');
$routes->post('mapping/create', 'Mapping::save');
$routes->post('datek/create', 'Datek::save');

//$routes->get('hostname/edit/(:any)', 'HostnameEdit::index/$1');

$routes->post('hostname/update/(:num)', 'Hostname::update/$1');
$routes->post('link/update/(:num)', 'Link::update/$1');
$routes->post('datek/update/(:num)', 'Datek::update/$1');
$routes->post('sistem/update/(:num)', 'Stransport::update/$1');
$routes->post('mapping/update/(:num)', 'Mapping::update/$1');

$routes->get('hostname/delete/(:num)', 'Hostname::delete/$1');
$routes->get('link/delete/(:num)', 'Link::delete/$1');
$routes->get('datek/delete/(:num)', 'Datek::delete/$1');
$routes->get('sistem/delete/(:num)', 'Stransport::delete/$1');
$routes->get('mapping/delete/(:num)', 'Mapping::delete/$1');

$routes->get('error', 'Link::error');
$routes->get('aksi', 'Link::aksi');
/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
